// By EVOLVED
// www.evolved-software.com

//-------------
// tweaks
//--------------
   float4 ViewSize1;
   float4 ViewSize2;
   float4x4 View;
   float4 ViewProj1;
   float4 ViewProj2;
   float4 ViewProj3;
   float4 ViewProj4;
   float4 ViewProjInv1;
   float4 ViewProjInv2;
   float4 ViewProjInv3;
   float4 ViewProjInv4;
   float Radius=8.0;
   float SSAOPower=0.75;
   float3 SamplesOffset[16]=
    {
     float3(0.355512,-0.709318,-0.102371),
     float3(0.534186,0.71511,-0.115167),
     float3(-0.87866,0.157139,-0.115167),
     float3(0.140679,-0.475516,-0.0639818),
     float3(-0.0796121,0.158842,-0.677075),
     float3(-0.0759516,-0.101676,-0.483625),
     float3(0.12493,-0.0223423,-0.483625),
     float3(-0.0720074,0.243395,-0.967251),
     float3(-0.207641,0.414286,0.187755),
     float3(-0.277332,-0.371262,0.187755),
     float3(0.63864,-0.114214,0.262857),
     float3(-0.184051,0.622119,0.262857),
     float3(0.110007,-0.219486,0.435574),
     float3(0.235085,0.314707,0.696918),
     float3(-0.290012,0.0518654,0.522688),
     float3(0.0975089,-0.329594,0.609803)
    };

//--------------
// Textures
//--------------
   texture DepthTexture <string Name = " ";>;
   sampler DepthSampler=sampler_state 
      {
	Texture=<DepthTexture>;
      	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;
      };
   texture NoiseTexture <string Name = "";>;
   sampler NoiseSampler=sampler_state 
      {
	Texture=<NoiseTexture>;
	MagFilter=None;
	MinFilter=None;
	MipFilter=None;
      };

//--------------
// structs 
//--------------
   struct InPut
     {
 	float4 Pos:POSITION;
     };
   struct OutPut
     {
	float4 Pos:POSITION; 
 	float4 Tex:TEXCOORD0;
 	float2 ClipSpace:TEXCOORD1;
     };

//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN) 
     {
 	OutPut OUT;
	OUT.Pos=IN.Pos;
 	OUT.Tex.xy=(float2(IN.Pos.x,-IN.Pos.y)+1.0)*0.5;
	OUT.Tex.zw=0.0;
 	OUT.Tex=(OUT.Tex*ViewSize2)+ViewSize1;
	OUT.ClipSpace=float2(IN.Pos.x,-IN.Pos.y);
	return OUT;
     }

//--------------
// pixel shader
//--------------
   float4 PS(OutPut IN) : COLOR
     {
	float4x4 ViewProj=float4x4(ViewProj1,ViewProj2,ViewProj3,ViewProj4);
	float4x4 ViewProjInv=float4x4(ViewProjInv1,ViewProjInv2,ViewProjInv3,ViewProjInv4);
	float Depth=tex2Dlod(DepthSampler,IN.Tex);
	float4 WorldPos=mul(float4(IN.ClipSpace,Depth,1),ViewProjInv);
	WorldPos.xyz /=WorldPos.w;
	float3 Normals=normalize(cross(ddx(WorldPos.xyz),ddy(WorldPos.xyz)));
	float Bias=(1/Depth)*0.01;
	float DepthRadius=Radius+Bias;
	float3 ViewNormal=mul(float4(Normals.xyz,0),View);
	float3 Noise=tex2Dlod(NoiseSampler,WorldPos.xzyz+WorldPos.y);
	float3 Tangent=normalize(Noise-ViewNormal*dot(Noise,ViewNormal));
	float3x3 TBN={Tangent,cross(ViewNormal,Tangent),ViewNormal};
        float Occlude=0;
	for (int i=0; i < 16; i++) {
	 float3 Hemisphere=mul(SamplesOffset[i],TBN);
	 if(dot(Hemisphere,Normals)<0) Hemisphere +=Normals;
	 float4 Proj=mul(float4(WorldPos.xyz+Hemisphere*DepthRadius,1),ViewProj);
	 Proj.z=1/(Proj.z/Proj.w);
	 float Depth=1/tex2Dlod(DepthSampler,(Proj/Proj.w)*0.5+0.5).x;
	 Occlude +=step(Depth+Bias,Proj.z)*smoothstep(0,1,DepthRadius/(Proj.z-Depth));
	}
	return 1-pow(Occlude/16,SSAOPower);
     }

//--------------
// techniques   
//--------------
    technique SSAO
      {
 	pass p1
      {		
 	VertexShader = compile vs_3_0 VS();
 	PixelShader  = compile ps_3_0 PS();
        ColorWriteEnable=8;
      }
      }
